dofile(LockOn_Options.script_path.."HUD\\HUD_definitions.lua")

-----------------------------------------------------------------------
--
-- software clip
--

-----------------------------------------------------------------------

function add_filter_hud_only()

local	filter			  = CreateElement "ceMeshPoly"
		filter.name		  = "filter"
		filter.primitivetype = "triangles"
		filter.vertices	  = {{-0.9, 0},
							 {-0.9, 2},
							 {0.9 , 2},
							 {0.9 , 0}}
		filter.indices	  = default_box_indices
		filter.init_pos	  = {0.0, -1.0, -0.2}
		filter.init_rot   = {0.0, 0.0, 90.0}
		filter.material   = "BROWN_GLASS"
		filter.collimated = false
		filter.controllers= {{"render_purpose",render_purpose.HUD_ONLY_VIEW},{"filter_rotate",-1}}
		Add(filter)
end

add_filter_hud_only()

if not flag_hardware_clip then
	collimator_borders = create_HUD_element("ce_s_ClipBordersSet")
	collimator_borders.name = "collimator_borders"
	collimator_borders.borders_quantity = 2

	verts_arrays = {}

	num_points = 16
	radius = 0.95
	step = math.rad(360.0/num_points)
	subverts1 = {}
	for i = 0, 8 do
		subverts1[i] = {radius * math.cos(i * step), radius * math.sin(i * step)}
	end
	subverts1[9] = {-0.86, -0.3}
	subverts1[10] = {0.86, -0.3}
	verts_arrays[0] = subverts1

	for k, v in subverts1 do
		v[2] = v[2] + 0.6
	end

	subverts2 = {}
	subverts2[0] = {radius, 0.0}
	subverts2[1] = {0.86, 0.3}
	subverts2[2] = {-0.86, 0.3}
	for i = 8, 15 do
		subverts2[i - 5] = {radius * math.cos(i * step), radius * math.sin(i * step)}
	end
		
	verts_arrays[1] = subverts2

	collimator_borders.verts_arrays  = verts_arrays
	collimator_borders.common_points = {{0.86, 0.3}, {-0.86, 0.3}}
	collimator_borders.init_pos		 = {0.0, -0.1, 0}
	collimator_borders.material      = "BLUE"

--[[
	collimator_borders.regions   = {"pitch_bank_scale_border",
									"bird_mark_region",
									"airspeed_scale_region",
									"airspeed_index_region",
									"ny_scale_region",
									"ny_index_region",
									"alpha_scale_region",
									"alpha_scale_index_region",
									"ralt_scale_region",
									"ralt_scale_index_region",
									"heading_tape_region",
									"heading_index_region",
								}
--]]

	collimator_borders.immediate_elements  = {"txt_poly"}

	collimator_borders.isdraw   = true
	AddBordersSet(collimator_borders);

else

-----------------------------------------------------------------------
--
-- hardware clip
--
-----------------------------------------------------------------------

--[[
	collimator_borders1 = create_HUD_element("ceMeshPoly")
	collimator_borders1.name = "collimator_borders1"
	collimator_borders1.primitivetype = "triangles"

	num_points = 32
	radius = 0.95
	horisontal_K = 1.0
	vertical_K = 1.45
	step = math.rad(360.0/num_points)

	vertical_offset = 0.0
	verts1 = {}
	for i = 1, 32 do
		verts1[i] = {(radius * math.cos(i * step)) * horisontal_K, (radius * math.sin(i * step) + vertical_offset) * vertical_K}
	end
	
	collimator_borders1.vertices = verts1
	
	inds1 = {}
	j = 0
	for i = 0, 29 do
		j = j + 1
		inds1[j] = 0
		j = j + 1
		inds1[j] = i + 1
		j = j + 1
		inds1[j] = i + 2
	end

	collimator_borders1.indices		 = inds1
	collimator_borders1.init_pos	 = {0.0, -0.35, 0.2}
	collimator_borders1.init_rot     = {0.0, 0.0, -46.0}
	collimator_borders1.material		= "GREEN_2"
	collimator_borders1.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	collimator_borders1.level		= DEFAULT_LEVEL
	collimator_borders1.isdraw		= true
	collimator_borders1.change_opacity = false
	--collimator_borders1.collimated	   = true
	Add(collimator_borders1)
	
	collimator_borders2 = create_HUD_element("ceMeshPoly")
	collimator_borders2.name = "collimator_borders2"
	collimator_borders2.primitivetype = "triangles"

	verts = {}
	verts[1] = {0.9 * horisontal_K, (-0.17 + vertical_offset) * vertical_K}
	for i = 0, 16 do
		verts[i + 2] = {(radius * math.cos(i * step)) * horisontal_K, (radius * math.sin(i * step) + vertical_offset) * vertical_K}
	end
	verts[19] = {-0.9 * horisontal_K, (-0.17 + vertical_offset) * vertical_K}
		
	collimator_borders2.vertices = verts
	
	inds = {}
	j = 0
	for i = 0, 16 do
		j = j + 1
		inds[j] = 0
		j = j + 1
		inds[j] = i + 1
		j = j + 1
		inds[j] = i + 2
	end

	collimator_borders2.indices		 = inds
	collimator_borders2.init_pos	 = {0.0, 0.22, 0.85}
	collimator_borders2.init_rot     = {0.0, 0.0, -46.0}
	collimator_borders2.material		= "GREEN_2"
	collimator_borders2.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	collimator_borders2.level		= DEFAULT_LEVEL
	collimator_borders2.isdraw		= true
	collimator_borders2.change_opacity = false
	--collimator_borders2.collimated	   = true
	Add(collimator_borders2)
--]]

	total_field_of_view = create_HUD_element("ceMeshPoly")
	total_field_of_view.name = "total_field_of_view"
	total_field_of_view.primitivetype = "triangles"

	num_points = 32
	radius = 1.55
	step = math.rad(360.0/num_points)

	verts = {}
	for i = 1, num_points do
		verts[i] = {(radius * math.cos(i * step)), (radius * math.sin(i * step))}
	end
	
	total_field_of_view.vertices = verts
	
	inds = {}
	j = 0
	for i = 0, 29 do
		j = j + 1
		inds[j] = 0
		j = j + 1
		inds[j] = i + 1
		j = j + 1
		inds[j] = i + 2
	end

	total_field_of_view.indices			= inds
	total_field_of_view.init_pos		= bird_position
	total_field_of_view.material		= "GREEN_2"
	total_field_of_view.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	total_field_of_view.level			= HUD_FOV_LEVEL
	total_field_of_view.isdraw			= true
	total_field_of_view.change_opacity	= false
	total_field_of_view.isvisible		= false
	Add(total_field_of_view)

	collimator_border_near			  = create_HUD_element("ceTexPoly")
	collimator_border_near.name		  = "collimator_border_near"
	collimator_border_near.vertices	  = {{-0.9, -1.2}, {-0.9,  0.8}, {0.9, 0.8}, {0.9, -1.2}}
	collimator_border_near.indices	  = default_box_indices
	collimator_border_near.init_pos	  = {0.0, -0.35, 0.2}
	collimator_border_near.init_rot   = {0.0, 0.0, -46.0}
	collimator_border_near.material   = "INDICATION_HUD_KA50_BORDER_NEAR"
	collimator_border_near.tex_params = {0.5, 0.5, 0.42, 0.42}
	collimator_border_near.collimated = false
	Add(collimator_border_near)
	
	collimator_border_near_clipper			  = create_HUD_element("ceTexPoly")
	collimator_border_near_clipper.name		  = "collimator_border_near_clipper"
	collimator_border_near_clipper.vertices	  = collimator_border_near.vertices
	collimator_border_near_clipper.indices	  = default_box_indices
	collimator_border_near_clipper.init_pos	  = collimator_border_near.init_pos
	collimator_border_near_clipper.init_rot   = collimator_border_near.init_rot
	collimator_border_near_clipper.material   = "INDICATION_HUD_KA50_BORDER_NEAR"
	collimator_border_near_clipper.tex_params = collimator_border_near.tex_params
	collimator_border_near_clipper.h_clip_relation = h_clip_relations.INCREASE_IF_LEVEL
	collimator_border_near_clipper.level	  = HUD_FOV_LEVEL
	collimator_border_near_clipper.isvisible  = false
	collimator_border_near_clipper.collimated = false
	Add(collimator_border_near_clipper)
	
	--[[	
	dbg_collimator_border_near_box			     = create_HUD_element("ceMeshPoly")
	dbg_collimator_border_near_box.name		     = "dbg_collimator_border_near_box"
	dbg_collimator_border_near_box.primitivetype = "lines"
	dbg_collimator_border_near_box.vertices		 = collimator_border_near.vertices
	dbg_collimator_border_near_box.indices	     = default_rect_indices
	dbg_collimator_border_near_box.init_pos		 = collimator_border_near.init_pos
	dbg_collimator_border_near_box.init_rot		 = collimator_border_near.init_rot
	dbg_collimator_border_near_box.material      = "GREEN"
	Add(dbg_collimator_border_near_box)
	--]]
	
	collimator_border_far				= create_HUD_element("ceTexPoly")
	collimator_border_far.name			= "collimator_border_far"
	collimator_border_far.vertices		= {{-0.95, -0.6}, {-0.95,  1.35}, {0.95, 1.35}, {0.95, -0.6}}
	collimator_border_far.indices		= default_box_indices
	collimator_border_far.init_pos		= {0.0, 0.14, 0.85}
	collimator_border_far.init_rot		= {0.0, 0.0, -46.0}
	collimator_border_far.material		= "INDICATION_HUD_KA50_BORDER_FAR"
	collimator_border_far.tex_params	= {0.5, 0.5, 0.37, 0.37}
	collimator_border_far.collimated	= false
	Add(collimator_border_far)
	
	collimator_border_far_clipper				= create_HUD_element("ceTexPoly")
	collimator_border_far_clipper.name			= "collimator_border_far_clipper"
	collimator_border_far_clipper.vertices		= collimator_border_far.vertices
	collimator_border_far_clipper.indices		= default_box_indices
	collimator_border_far_clipper.init_pos		= collimator_border_far.init_pos
	collimator_border_far_clipper.init_rot		= collimator_border_far.init_rot
	collimator_border_far_clipper.material		= "INDICATION_HUD_KA50_BORDER_FAR"
	collimator_border_far_clipper.tex_params	= collimator_border_far.tex_params
	collimator_border_far_clipper.h_clip_relation = h_clip_relations.INCREASE_IF_LEVEL
	collimator_border_far_clipper.level			= HUD_FOV_LEVEL
	collimator_border_far_clipper.isvisible		= false
	collimator_border_far_clipper.collimated	= false
	Add(collimator_border_far_clipper)
	
	--[[
	dbg_collimator_border_far_box			     = create_HUD_element("ceMeshPoly")
	dbg_collimator_border_far_box.name		     = "dbg_collimator_border_far_box"
	dbg_collimator_border_far_box.primitivetype = "lines"
	dbg_collimator_border_far_box.vertices		 = collimator_border_far.vertices
	dbg_collimator_border_far_box.indices	     = default_rect_indices
	dbg_collimator_border_far_box.init_pos		 = collimator_border_far.init_pos
	dbg_collimator_border_far_box.init_rot		 = collimator_border_far.init_rot
	dbg_collimator_border_far_box.material      = "GREEN"
	Add(dbg_collimator_border_far_box)
	--]]
end

flag_draw_refgrid = false

-- reference grid
if flag_draw_refgrid then
	size = 1.0
	init_angle = 15
	half = 1
	for i = 0, 60 do
		
		if half == 1 then
			half = 0
		else
			half = 1
		end
		
		if i == 0 or i == 10 or i == 20 or i == 30 or i == 40 or i == 50 or i == 60 then
			sizeK = 4.0
		elseif half == 1 then
			sizeK = 0.25
		else
			sizeK = 2.0
		end
		
		local elv = create_HUD_element("ceMeshPoly")
		elv.name       = "elv" .. string.format("%i", i)
		elv.primitivetype = "lines"
		elv.vertices   = {{-0.45 * size * sizeK, 0.0}, {0.45 * size * sizeK, 0.0}}
		elv.indices    = {0, 1}
		elv.init_pos   = {0.0, 0.0, 0}
		elv.material   = "GREEN"
		elv.controllers = {{"dbg_linegrid", 1, math.rad(init_angle)}}
		Add(elv)
		
		init_angle = init_angle - 0.5
	end

	init_angle = 15
	half = 1
	for i = 0, 60 do

		if half == 1 then
			half = 0
		else
			half = 1
		end
		
		if i == 0 or i == 10 or i == 20 or i == 30 or i == 40 or i == 50 or i == 60 then
			sizeK = 4.0
		elseif half == 1 then
			sizeK = 0.25
		else
			sizeK = 2.0
		end

		local elg = create_HUD_element("ceMeshPoly")
		elg.name       = "elg" .. string.format("%i", i)
		elg.primitivetype = "lines"
		elg.vertices   = {{0.0, -0.45 * size * sizeK}, {0.0, 0.45 * size * sizeK}}
		elg.indices    = {0, 1}
		elg.init_pos   = {0.0, 0.0, 0}
		elg.material   = "GREEN"
		elg.controllers = {{"dbg_linegrid", 0, math.rad(init_angle)}}
		Add(elg)
		
		init_angle = init_angle - 0.5
	end
end



-- TEST
--[[
txt_test			= create_HUD_element("ceStringPoly")
txt_test.name		= "txt_test"
txt_test.material	= "font_Ka-50_HUD"
txt_test.init_pos	= {0.0,  0.0, 0}
txt_test.value      = " !\"+-./0123456789:ABC\nDEFGHIJKLMNOPQRSTU\nVWXYZ\\|АБВГДЕЖЗИЙКЛМ\nНОПРСТУФХЦЧШЩЪЫЬЭЮ\150\n\150"
txt_test.alignment  = "LeftBottom"
txt_test.stringdefs	= {0.0105, 0.0105, 0.01 * 0.01, 0.05 * 0.01}
Add(txt_test)
--]]
